/* Virtual Array Header File */
#include <alloc.h>
#include <stdio.h>

/* Virtual Array Control Block typedef */

typedef struct {

   FILE *file;           /* pointer to file control block */
   long size;            /* number of array elements in file */
   int  elsize;          /* number of bytes in each element */
   char *buffer;         /* pointer to array buffer */
   int  buf_elsize;      /* size of element in buffer including index */
   int  buf_size;        /* number of elements in buffer */
   char *blank_rec;      /* pointer to initialization record */
                         /* used for extending file */
} VACB ;                 /* virtual array control block type name */

/* Virtual Array Access Prototypes */

int init_v_array(char *filename,int rec_size,char filchar);
VACB *open_v_array(char *filename,int buffer_size);
void close_v_array(VACB *v_array);
void *access_v_rec(VACB *v_array,long index);
